<?php

namespace Inside\Permission\Exodus\Listeners;

use Inside\Content\Events\ContentCreatedEvent;
use Inside\Content\Models\Content;
use Inside\Permission\Exodus\Actions\GenerateMissing\GenerateMissingCategorizablePrivileges;
use Inside\Permission\Exodus\Actions\RefreshViewTables\RefreshCategorizableContentIndexesViewTable;
use Inside\Permission\Exodus\Actions\RefreshViewTables\RefreshCategorizableContentTranslationIndexesViewTable;
use Inside\Permission\Exodus\Services\GrantDefaultPrivilege\GrantDefaultCategorizableContentPrivileges;
use Inside\Permission\Exodus\Services\RolePrivilegesService;

class CreatePrivilegesOnNewCategorizableContent
{
    public function handle(ContentCreatedEvent $event): void
    {
        if (! $event->model instanceof Content) {
            return;
        }

        $model = $event->model;

        if (! $model::isPermissible() || ! $model::isCategorizable()) {
            return;
        }

        (new RefreshCategorizableContentIndexesViewTable())->execute();
        (new RefreshCategorizableContentTranslationIndexesViewTable())->execute();
        (new GenerateMissingCategorizablePrivileges())->execute();

        GrantDefaultCategorizableContentPrivileges::of($model);
        RolePrivilegesService::clearAllCache();
    }
}
