<?php

namespace Inside\Permission\Exodus\Listeners;

use Illuminate\Support\Facades\Log;
use Inside\Menu\Events\MenuCreatedEvent;
use Inside\Permission\Exodus\Actions\GenerateMissing\GenerateMissingMenuPrivileges;
use Inside\Permission\Exodus\Actions\RefreshViewTables\RefreshMenuIndexesViewTable;
use Inside\Permission\Exodus\Models\Privileges\MenuPrivilege;
use Inside\Permission\Exodus\Models\Role;
use Inside\Permission\Exodus\Services\RolePrivilegesService;

class CreateAndGrantPrivilegesOnNewMenu
{
    public function handle(MenuCreatedEvent $event): void
    {
        $menu = $event->model;

        (new GenerateMissingMenuPrivileges())->execute();
        (new RefreshMenuIndexesViewTable())->execute();

        /** @var Role $defaultRole */
        $defaultRole = Role::query()->withCount('users')->orderByDesc('users_count')->first();

        $privilege = MenuPrivilege::query()->whereHas('index', fn ($query) => $query->where('uuid', $menu->uuid)->where('type', $menu::class))->first();

        if (! $privilege) {
            Log::warning("[Inside Menu] Menu privilege not found for {$menu->uuid}");
        } else {
            $defaultRole->menuPrivileges()->attach($privilege);
        }

        RolePrivilegesService::clearAllCache();
    }
}
