<?php

declare(strict_types=1);

namespace Inside\Permission\Exodus\Jobs;

use Exception;
use Illuminate\Support\Facades\Log;
use Inside\Jobs\Job;
use Inside\Permission\Exodus\Models\Role;
use Inside\Permission\Exodus\Services\RolePrivilegesService;

final class ComputeRoleRestriction extends Job
{
    public function __construct(
        /**
         * @var Collection<Role> $roles
         */
        protected Role $role
    ) {
    }

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        Log::info("[ComputeRoleRestrictions] Computing role restrictions for role {$this->role->name} ({$this->role->id})");
        $this->role->computeRestriction();
    }
}
