<?php

namespace Inside\Permission\Exodus\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Arr;
use Illuminate\Support\Collection;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Content;
use Inside\Permission\Exodus\Actions\StorePrivileges\StoreContentTypePrivileges;
use Inside\Permission\Exodus\Actions\StorePrivileges\StoreMenuPrivileges;
use Inside\Permission\Exodus\Dto\Privileges\MenuPrivilegeDto;
use Inside\Permission\Exodus\Http\Resources\ContentTypePrivilegeCollection;
use Inside\Permission\Exodus\Http\Resources\MenuPrivilegeCollection;
use Inside\Permission\Exodus\Models\Role;
use Inside\Permission\Exodus\Models\ViewModels\CategorizableContentTranslationIndexes;
use Inside\Permission\Exodus\Services\ComputeRestriction\ComputeRestrictionService;
use Inside\Permission\Exodus\Services\RolePrivilegesService;

class PrecomputeCapabilitiesOnContent extends Controller
{
    public function __invoke(Request $request, string $type): JsonResponse
    {
        /** @var Content $content */
        $content = new (type_to_class($type))();

        $categorizables = $content::getCategorizableRequiredRelations();

        $restrictions = collect(Arr::only($request->toArray(), $categorizables))->mapWithKeys(function ($value, $key) {
            return [type_to_class($key) => is_string($value) ? [$value] : $value];
        });

        $indexes = CategorizableContentTranslationIndexes::query()->whereIn('translatable_uuid', $restrictions->values()->flatten()->unique())->get();

        $restrictions->transform(function ($value, $uuids) use ($indexes) {
            return $indexes->whereIn('translatable_uuid', $value)->pluck('uuid_host')->unique()->values()->toArray();
        });

        return response()->json(
            ComputeRestrictionService::precomputeCapabilitiesOnContentForRoles($content, $restrictions->toArray())
        );
    }
}
