<?php

namespace Inside\Permission\Exodus\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Collection;
use Inside\Authentication\Models\User;
use Inside\Permission\Exodus\Actions\StorePrivileges\StoreBackofficePrivileges;
use Inside\Permission\Exodus\Dto\Privileges\BackofficePrivilegeDto;
use Inside\Permission\Exodus\Http\Resources\BackofficePrivilegeCollection;
use Inside\Permission\Exodus\Models\Role;
use Inside\Permission\Exodus\Services\RolePrivilegesService;

class BackofficeAccessRestriction extends Controller
{
    public function index(Request $request, int $roleId): JsonResponse
    {
        /** @var Role $role */
        $role = Role::query()->find($roleId);

        /** @var Collection<BackofficePrivilegeDto> $privileges */
        $privileges = $role->getAccessRestriction()->getBackofficePrivileges();

        $inheritance = $role->name !== Role::AUTHENTICATED;

        $request->setDefaultLocale(config('app.locale'));

        return response()->json(BackofficePrivilegeCollection::from($privileges, $request->getLocale(), $inheritance)->toArray());
    }

    public function store(Request $request, int $roleId): JsonResponse
    {
        /** @var Role $role */
        $role = Role::query()->find($roleId);

        (new StoreBackofficePrivileges())->execute($role, $request->get('data'));

        return response()->json();
    }

    public function combined(Request $request, string $userUuid): JsonResponse
    {
        /** @var Collection<Role> $roles */
        $roles = User::find($userUuid)?->roles()->withoutDeprecatedRoles()->get();

        /** @var Collection<BackofficePrivilegeDto> $privileges */
        $privileges = RolePrivilegesService::of(...$roles)->getBackofficePrivileges();

        $request->setDefaultLocale(config('app.locale'));

        return response()->json([
            'data' => data_get(BackofficePrivilegeCollection::from($privileges, $request->getLocale())->toArray(), 'data', []),
            'roles' => $roles->pluck('name')->toArray(),
        ]);
    }
}
