<?php

namespace Inside\Permission\Exodus\Dto;

use Inside\Menu\Models\MenuLink;

/**
 * @todo PHP8.2: use readonly properties, switch to public visibility and remove getters
 */
final class MenuDto extends BaseDtoImplementation
{
    private function __construct(
        public string $title,
        public string $langcode,
        public int $weight,
        public ?string $parent_uuid,
    ) {
    }

    public static function from(string $title, string $langcode, int $weight, ?string $parent_uuid = null): self
    {
        return new self($title, $langcode, $weight, $parent_uuid);
    }

    public static function fromModel(MenuLink $model): self
    {
        return self::from(
            $model->title,
            $model->langcode,
            $model->weight,
            $model->parent_uuid,
        );
    }

    public function primaryKey(): string
    {
        return 'uuid';
    }

    public function getParentUuid(): ?string
    {
        return $this->parent_uuid;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getLangcode(): string
    {
        return $this->langcode;
    }

    public function getWeight(): int
    {
        return $this->weight;
    }

    public function toArray(): array
    {
        return [
            'title' => $this->title,
            'langcode' => $this->langcode,
            'weight' => $this->weight,
            'parent_uuid' => $this->parent_uuid,
        ];
    }
}
