<?php

namespace Inside\Permission\Exodus\Dto\Indexes;

use Illuminate\Support\Collection;
use Inside\Permission\Exodus\Dto\BaseDtoImplementation;
use Inside\Permission\Exodus\Models\ViewModels\CategorizableContentIndex;
use Inside\Permission\Exodus\Models\ViewModels\CategorizableContentTranslationIndexes;

/**
 * @todo PHP8.2: use readonly properties, switch to public visibility and remove getters
 */
final class PermissibleContentIndexDto extends BaseDtoImplementation
{
    private function __construct(
        public string $uuid_host,
        public string $type,
        /** @var Collection<PermissibleContentTranslationIndexDto> $translations */
        public Collection $translations,
    ) {
    }

    public static function from(string $uuid_host, string $type, Collection $translations): self
    {
        return new self($uuid_host, $type, $translations);
    }

    public static function fromModel(CategorizableContentIndex $model): self
    {
        return self::from(
            uuid_host: $model->uuid_host,
            type: $model->type,
            translations: $model->translations->isNotEmpty()
                ? $model->translations->map(fn (CategorizableContentTranslationIndexes $translation) => PermissibleContentTranslationIndexDto::fromModel($translation))
                : collect(),
        );
    }

    public function primaryKey(): string
    {
        return 'uuid_host';
    }

    public function getUuidHost(): string
    {
        return $this->uuid_host;
    }

    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return Collection<PermissibleContentTranslationIndexDto>
     */
    public function getTranslations(): Collection
    {
        return $this->translations;
    }

    public function getTranslatableUuid(): string
    {
        return '';
    }

    public function toArray(): array
    {
        return [
            $this->primaryKey() => $this->uuid_host,
            'type' => $this->type,
            'translations' => $this->translations->map(
                fn (PermissibleContentTranslationIndexDto $translation) => $translation->toArray()
            )->toArray(),
        ];
    }
}
