<?php

namespace Inside\Permission\Exodus\Dto;

use Illuminate\Support\Collection;

abstract class BaseDtoImplementation
{
    abstract public function primaryKey(): string;

    abstract public function toArray(): array;

    public function collect(): Collection
    {
        return collect($this->toArray());
    }

    /**
     * This __toString method permits to compare DTO as a string and allow to use diff() method from Illuminate Collection.
     *
     * @return string
     */
    public function __toString(): string
    {
        return json_encode($this->collect()->forget($this->primaryKey())->toArray()) ?: '';
    }
}
