<?php

namespace Inside\Permission\Exodus\Actions\RemoveUnnecessaries;

use Inside\Permission\Exodus\Dto\Privileges\MenuPrivilegeDto;
use Inside\Permission\Exodus\Models\Privileges\MenuPrivilege;
use Inside\Permission\Exodus\Services\AccessRestriction\MenuAccessRestriction;

final class RemoveUnnecessaryMenuPrivileges
{
    public function execute(): int
    {
        $unnecessaries = MenuAccessRestriction::unnecessaries()->map(fn (MenuPrivilegeDto $dto) => $dto->getId())->values();

        MenuPrivilege::query()->whereIn('id', $unnecessaries->toArray())->delete();

        return $unnecessaries->count();
    }
}
