<?php

namespace Inside\Permission\Exodus\Actions\RemoveUnnecessaries;

use Inside\Permission\Exodus\Dto\CapabilityDto;
use Inside\Permission\Exodus\Models\Capability;
use Inside\Permission\Exodus\Services\AccessRestriction\CapabilityAccessRestriction;

final class RemoveUnnecessaryCapabilities
{
    public function execute(): int
    {
        $unnecessaries = CapabilityAccessRestriction::unnecessaries()->map(fn (CapabilityDto $dto) => $dto->getId())->values();

        Capability::query()->whereIn('id', $unnecessaries->toArray())->delete();

        return $unnecessaries->count();
    }
}
