<?php

namespace Inside\Permission\Exodus\Actions\RemoveUnnecessaries;

use Inside\Permission\Exodus\Dto\Privileges\BackofficePrivilegeDto;
use Inside\Permission\Exodus\Models\Privileges\BackofficePrivilege;
use Inside\Permission\Exodus\Services\AccessRestriction\BackofficeAccessRestriction;

final class RemoveUnnecessaryBackofficeSections
{
    public function execute(): int
    {
        $unnecessaries = BackofficeAccessRestriction::unnecessaries()->map(fn (BackofficePrivilegeDto $dto) => $dto->getId())->values();

        BackofficePrivilege::query()->whereIn('id', $unnecessaries->toArray())->delete();

        return $unnecessaries->count();
    }
}
