<?php

namespace Inside\Permission\Exodus\Actions\PermissionLogic\User;

use Inside\Authentication\Models\User;
use Inside\Content\Models\Content;
use Inside\Permission\Exodus\Enums\CapabilityEnum;
use Inside\Permission\Scopes\AllowedScope;

class CanReadContent
{
    public function handle(User $user, Content $content): bool
    {
        // Check if the user is super admin
        if ($user->isSuperAdmin()) {
            return true;
        }

        // Check if the content type is permissible, if not, the content must be readable.
        if (! $content::isPermissible()) {
            return true;
        }

        // Check if at least one of the user's roles has the capability to read the content.
        return match ($content::isCategorizable()) {
            true => $user->getRolePrivilegesService()->canReadCategorizableContent($content),
            false => $user->getRolePrivilegesService()->canReadContent($content),
        };
    }
}
