<?php

namespace Inside\Permission\Exodus\Actions\PermissionLogic\User;

use Inside\Authentication\Models\User;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Content;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Exodus\Services\ContentTypeStatusService;
use Inside\Permission\Exodus\Dto\Privileges\ContentPrivilegeDto;
use Inside\Permission\Exodus\Enums\BackofficeEnum;
use Inside\Permission\Exodus\Enums\CapabilityEnum;
use Inside\Permission\Exodus\Models\Capability;
use Inside\Permission\Exodus\Services\RolePrivilegesService;

class CanDeleteContent
{
    public function handle(User $user, Content $content): bool
    {
        // Check if the user is super admin
        if ($user->isSuperAdmin()) {
            return true;
        }

        // Users content is not permissible, the user must have backoffice access to create a user.
        if ($content instanceof Users) {
            return $user->hasBackofficeAccessTo('user');
        }

        // Check if the content type is permissible, if not, it's not possible to delete the content.
        if (! $content::isPermissible()) {
            return false;
        }

        // Check if the user has permission to delete the content type.
        if (! $user->hasContentTypePrivilegeTo(CapabilityEnum::DELETE, $content)) {
            return false;
        }

        // Check if at least one of the user's roles has the capability to delete the content.
        return match ($content::isCategorizable()) {
            true => $user->getRolePrivilegesService()->canDeleteCategorizableContent($content),
            false => $user->getRolePrivilegesService()->canDeleteContent($content),
        };
    }
}
