<?php

namespace Inside\Permission\Exodus\Actions\PermissionLogic\Role;

use Inside\Content\Models\Content;
use Inside\Permission\Exodus\Enums\CapabilityEnum;
use Inside\Permission\Exodus\Models\Role;

class CanReadContent
{
    public function handle(Role $role, Content $content): bool
    {
        if ($role->isSuperAdmin()) {
            return true;
        }

        // Check if the content type is permissible, if not, the content must be readable.
        if (! $content::isPermissible()) {
            return true;
        }

        // Check if at least one of the user's roles has the capability to read the content.
        return match ($content::isCategorizable()) {
            true => $role->getAccessRestriction()->canReadCategorizableContent($content),
            false => $role->getAccessRestriction()->canReadContent($content),
        };
    }
}
