<?php

namespace Inside\Permission\Exodus\Actions\GenerateMissing;

use Inside\Permission\Exodus\Dto\Privileges\MenuPrivilegeDto;
use Inside\Permission\Exodus\Models\Privileges\MenuPrivilege;
use Inside\Permission\Exodus\Services\AccessRestriction\MenuAccessRestriction;

final class GenerateMissingMenuPrivileges
{
    public function execute(): int
    {
        $missing = MenuAccessRestriction::missing()->map(fn (MenuPrivilegeDto $dto) => [
            'capability_id' => $dto->getCapability()->getId(),
            'index_uuid' => $dto->getIndex()?->getUuid(),
        ]);

        MenuPrivilege::query()->insert($missing->toArray());

        return $missing->count();
    }
}
