<?php

namespace Inside\Permission\Exodus\Actions\GenerateMissing;

use Inside\Permission\Exodus\Dto\Privileges\ContentTypePrivilegeDto;
use Inside\Permission\Exodus\Models\Privileges\ContentTypePrivilege;
use Inside\Permission\Exodus\Services\AccessRestriction\ContentTypeAccessRestriction;

final class GenerateMissingContentTypePrivileges
{
    public function execute(): int
    {
        $missing = ContentTypeAccessRestriction::missing()->map(fn (ContentTypePrivilegeDto $dto) => [
            'capability_id' => $dto->getCapability()->getId(),
            'type' => $dto->getType(),
        ]);

        ContentTypePrivilege::query()->insert($missing->toArray());

        return $missing->count();
    }
}
