<?php

namespace Inside\Permission\Exodus\Actions\GenerateMissing;

use Inside\Permission\Exodus\Dto\Privileges\ContentPrivilegeDto;
use Inside\Permission\Exodus\Models\Privileges\ContentPrivilege;
use Inside\Permission\Exodus\Services\AccessRestriction\ContentAccessRestriction;

final class GenerateMissingContentPrivileges
{
    public function execute(): int
    {
        $missing = ContentAccessRestriction::missing()->map(fn (ContentPrivilegeDto $dto) => [
            'capability_id' => $dto->getCapability()->getId(),
            'uuid' => $dto->getIndex()?->getTranslatableUuid(),
        ]);

        ContentPrivilege::query()->insert($missing->toArray());

        return $missing->count();
    }
}
