<?php

namespace Inside\Permission\Exodus\Actions\ConvertOldPermissions;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Inside\Host\Exodus\Services\ContentTypeStatusService;
use Inside\Permission\Exodus\Enums\CapabilityEnum;
use Inside\Permission\Exodus\Enums\MenuEnum;
use Inside\Permission\Exodus\Models\Capability;
use Inside\Permission\Exodus\Models\Privileges\ContentTypePrivilege;
use Inside\Permission\Exodus\Models\Privileges\MenuPrivilege;
use Inside\Permission\Exodus\Models\Role;

class ConvertOldMenuPermissions
{
    public function execute(): void
    {
        // Footers
        /** @var Role $defaultRole */
        $defaultRole = Role::query()->withCount('users')->orderByDesc('users_count')->first();

        $footers = MenuPrivilege::query()->whereHas('index', fn ($query) => $query->where('type', MenuEnum::FOOTER))->get()->pluck('id');

        $defaultRole->menuPrivileges()->sync($footers->toArray());

        // Headers
        $privileges = MenuPrivilege::query()->whereHas('index', fn ($query) => $query->where('type', MenuEnum::HEADER))->get();
        $roles = Role::where('name', 'not like', 'group-%')->get();

        Log::info('[Inside Permission] Converting old menu permissions');

        DB::table('inside_permissions')
            ->whereIn('uuid', $privileges->pluck('index_uuid'))
            ->whereIn('role_id', $roles->pluck('id'))
            ->get()
            ->map(fn ($permission) => [
                'role_id' => $permission->role_id,
                'privilege' => $privileges->firstWhere('index_uuid', $permission->uuid),
            ])
            ->groupBy('role_id')
            ->each(function ($permission, $role) use ($roles) {
                Log::info("[Inside Permission] Syncing roles [{$permission->pluck('role_id')->implode(', ')}] to privilege {$role}");

                $roles->firstWhere('id', $role)->menuPrivileges()->attach($permission->pluck('privilege')->pluck('id')->toArray());
            });
    }
}
