<?php

namespace Inside\Permission\Exodus\Actions\ConvertOldPermissions;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Inside\Host\Exodus\Services\ContentTypeStatusService;
use Inside\Permission\Exodus\Models\Privileges\ContentSpecificPrivilege;
use Inside\Permission\Exodus\Models\Role;

class ConvertOldContentSpecificPermissions
{
    public function execute(): void
    {
        $privileges = ContentSpecificPrivilege::all();
        $contentTypes = app(ContentTypeStatusService::class)->notCategorizables()->permissibles()->keys()->map(fn ($type) => type_to_class($type));
        $roles = Role::where('name', 'not like', 'group-%')->get();

        Log::info('[Inside Permission] Converting old content specific permissions');

        DB::table('inside_roles_permissions_schema')
            ->join('inside_permissions_schema', 'inside_roles_permissions_schema.permission_schema_id', '=', 'inside_permissions_schema.id')
            ->where('is_content_specific', true)
            ->whereNotNull('authorizable_uuid')
            ->whereNotNull('authorizable_type')
            ->where('action', 'read')
            ->whereIn('authorizable_type', $contentTypes->toArray())
            ->whereIn('role_id', $roles->pluck('id'))
            ->select(['role_id', 'authorizable_type', 'authorizable_uuid'])
            ->get()
            ->map(fn ($permission) => [
                'role_id' => $permission->role_id,
                'type' => $permission->authorizable_type,
                'uuid' => $permission->authorizable_uuid,
            ])
            ->groupBy('uuid')
            ->each(function ($roles, $uuid) use ($privileges) {
                Log::info("[Inside Permission] Syncing roles [{$roles->pluck('role_id')->implode(', ')}] to privilege {$uuid}");

                $privileges->firstWhere('uuid', $uuid)?->roles()->sync($roles->pluck('role_id'));
            });
    }
}
