<?php

namespace Inside\Permission\Exceptions;

use Symfony\Component\HttpKernel\Exception\HttpException;

final class UnauthorizedException extends HttpException
{
    /** @var array */
    private $requiredBackofficeEntries = [];

    public static function forBackofficeEntries(array $backofficeEntries): self
    {
        $exception = new self(403, __('permission.unauthorized.missing_backoffice_entry_access'), null, []);
        $exception->requiredBackofficeEntries = $backofficeEntries;

        return $exception;
    }

    public static function notLoggedIn(): self
    {
        return new self(403, __('permission.unauthorized.not_logged_in'), null, []);
    }

    public function getRequiredBackofficeEntries(): array
    {
        return $this->requiredBackofficeEntries;
    }
}
