<?php

namespace Inside\Permission\Exceptions;

use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpKernel\Exception\HttpException;

final class AuthorizationException extends HttpException
{
    public function __construct(string $message = null, \Exception $previous = null, int $code = 0)
    {
        parent::__construct(403, $message, $previous, [], $code);
    }

    public static function create(string $action, string $type, string $uuid = null): self
    {
        if (env('APP_DEBUG', false)) {
            $me = Auth::user();

            return new self('User <'.($me ? $me->email : 'guest').'> have no right to do {'.$action.'} on type {'.$type.'} ('.($uuid ? $uuid : 'NULL').')');
        } else {
            return new self('forbidden');
        }
    }
}
