<?php

namespace Inside\Permission\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Inside\Authentication\Models\User;
use Inside\Events\Dispatchable;
use Inside\Permission\Models\Role;

class RoleDetachedEvent implements ShouldBroadcast
{
    use Dispatchable;

    public function __construct(
        public User $user,
        public Role $role
    ) {
    }

    public function broadcastOn(): PrivateChannel
    {
        return new PrivateChannel('inside_permission.role.'.$this->role->id);
    }

    public function broadcastAs(): string
    {
        return 'inside_permission.role.users.removed';
    }
}
