<?php

namespace Inside\Permission\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Inside\Events\Dispatchable;
use Inside\Permission\Models\Role;

/**
 * Role created event.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class RoleCreatedEvent implements ShouldBroadcast
{
    use Dispatchable;

    public function __construct(
        public Role $role
    ) {
    }

    public function broadcastOn(): Channel
    {
        return new Channel('inside_role_created');
    }
}
