<?php

namespace Inside\Permission\Console;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;
use Inside\Permission\Facades\Permission;
use Inside\Permission\Services\PermissionService;

/**
 * Rebuild dynamic model command.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class PermissionsV2EnableCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'permissions:V2:enable';

    /**
     * @var string
     */
    protected $description = 'Enable system v2, you got the choice to switch between v1 and v2';

    /**
     * @throws \Exception
     */
    public function handle(): void
    {
        if (! PermissionService::isSystemV2Initialized()) {
            $this->error('You have to initialize the system v2 before migrating it.');

            return;
        }

        if (PermissionService::isSystemV2Migrated()) {
            $this->error('You have already definitively migrated the system v2.');

            return;
        }

        setting('permission', ['system_v2_enabled' => true]);

        $this->info('Enabling system v2.');
    }
}
