<?php

namespace Inside\Permission\Console;

use Illuminate\Support\Facades\DB;
use Inside\Console\Command;
use Inside\Content\Facades\Schema;
use Inside\Permission\Models\Role;
use Inside\Support\Str;

class FixPermissionSchemaCommand extends Command
{
    protected $name = 'inside:permission:fix';

    protected $signature = 'inside:permission:fix';

    protected $description = 'Vérifie l\'existence de schema de permission contradictoire et tente de les réparer!';

    public function handle(): void
    {
        $this->info('Vérification ...');
        Role::each(function ($role) {
            $this->warning('Schema du role ['.\Inside\Permission\Facades\Role::getHumanName($role->name).']');
            $schemas = DB::table('inside_permissions_schema')->join(
                'inside_roles_permissions_schema',
                'inside_permissions_schema.id',
                'inside_roles_permissions_schema.permission_schema_id'
            )->where('inside_roles_permissions_schema.role_id', $role->id)->where(
                'inside_roles_permissions_schema.is_content_specific',
                0
            )->whereNull('custom')->get();
            $bar = $this->getOutput()->createProgressBar($schemas->count());
            foreach ($schemas as $schema) {
                $query = DB::table('inside_permissions_schema')->join(
                    'inside_roles_permissions_schema',
                    'inside_permissions_schema.id',
                    'inside_roles_permissions_schema.permission_schema_id'
                )->where('inside_roles_permissions_schema.role_id', $role->id)->where(
                    'inside_roles_permissions_schema.is_content_specific',
                    0
                )->where('authorizable_uuid', $schema->authorizable_uuid)->where(
                    'authorizable_type',
                    $schema->authorizable_type
                )->whereNull('custom')->where('invert', ! $schema->invert)->where('action', $schema->action);
                if ($query->exists()) {
                    $query->delete();
                }
                $bar->advance();
            }
            $bar->finish();
            $this->writeln('');
            $this->line(str_repeat('-', 80));
        });
    }
}
