<?php

namespace Inside\Permission\Seeders;

use Illuminate\Database\Seeder;
use Inside\Permission\Models\Role;

class PermissionsSeeder extends Seeder
{
    public function run(): void
    {
        $roles = collect(
            [
                'anonymous',
                'authenticated',
                'webmaster',
                'administrator',
                'super_administrator',
            ]
        )->mapWithKeys(
            function ($name) {
                return [$name => Role::firstOrCreate(['name' => $name])];
            }
        );
    }
}
