<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Permission\Exodus\Models\Privileges\ContentTypePrivilege;
use Inside\Permission\Exodus\Models\Privileges\MenuPrivilege;
use Inside\Permission\Exodus\Models\Role;

class CreateMenuPrivilegeRolePivotTable extends Migration
{
    const ROLE_FOREIGN = MenuPrivilege::PIVOT_ROLE_TABLE.'_role_foreign';

    const MENU_FOREIGN = MenuPrivilege::PIVOT_ROLE_TABLE.'_menu_foreign';

    public function up() : void
    {
        Schema::create(MenuPrivilege::PIVOT_ROLE_TABLE, function (Blueprint $table) {
            $table->increments('pivot_id')->index();
            $table->integer('role_id')->unsigned();
            $table->integer('menu_privilege_id')->unsigned();

            $table->foreign('role_id', self::ROLE_FOREIGN)
                ->references('id')
                ->on(Role::TABLE)
                ->onDelete('cascade');

            $table->foreign('menu_privilege_id', self::MENU_FOREIGN)
                ->references('id')
                ->on(MenuPrivilege::TABLE)
                ->onDelete('cascade');
        });
    }

    public function down() : void
    {
        Schema::table(MenuPrivilege::PIVOT_ROLE_TABLE, function (Blueprint $table) {
            $table->dropForeign(self::ROLE_FOREIGN);
            $table->dropForeign(self::MENU_FOREIGN);
        });

        Schema::dropIfExists(ContentTypePrivilege::PIVOT_ROLE_TABLE);
    }
}
