<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Permission\Exodus\Models\Privileges\CategorizableContentPrivilege;
use Inside\Permission\Exodus\Models\Role;

class CreateCategorizableContentPrivilegeRolePivotTable extends Migration
{
    const ROLE_FOREIGN = CategorizableContentPrivilege::PIVOT_ROLE_TABLE.'_role_foreign';

    const CONTENT_FOREIGN = CategorizableContentPrivilege::PIVOT_ROLE_TABLE.'_cp_foreign';

    public function up() : void
    {
        Schema::create(CategorizableContentPrivilege::PIVOT_ROLE_TABLE, function (Blueprint $table) {
            $table->increments('pivot_id')->index();
            $table->integer('role_id')->unsigned();
            $table->integer('content_privilege_id')->unsigned();

            $table->foreign('role_id', self::ROLE_FOREIGN)
                ->references('id')
                ->on(Role::TABLE)
                ->onDelete('cascade');

            $table->foreign('content_privilege_id', self::CONTENT_FOREIGN)
                ->references('id')
                ->on(CategorizableContentPrivilege::TABLE)
                ->onDelete('cascade');
        });
    }

    public function down() : void
    {
        Schema::table(CategorizableContentPrivilege::PIVOT_ROLE_TABLE, function (Blueprint $table) {
            $table->dropForeign(self::ROLE_FOREIGN);
            $table->dropForeign(self::CONTENT_FOREIGN);
        });

        Schema::dropIfExists(CategorizableContentPrivilege::PIVOT_ROLE_TABLE);
    }
}
