<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Permission\Exodus\Models\Capability;
use Inside\Permission\Exodus\Models\Privileges\ContentTypePrivilege;

class CreateContentTypePrivilegesTable extends Migration
{
    const CAPABILITY_FOREIGN = ContentTypePrivilege::TABLE.'_cap_foreign';

    public function up() : void
    {
        Schema::create(ContentTypePrivilege::TABLE, function (Blueprint $table) {
            $table->increments('id')->index();
            $table->integer('capability_id')->unsigned();
            $table->string('type')->nullable();

            $table->foreign('capability_id', self::CAPABILITY_FOREIGN)
                ->references('id')
                ->on(Capability::TABLE)
                ->onDelete('cascade');
        });
    }

    public function down() : void
    {
        Schema::table(ContentTypePrivilege::TABLE, function (Blueprint $table) {
            $table->dropForeign(self::CAPABILITY_FOREIGN);
        });

        Schema::dropIfExists(ContentTypePrivilege::TABLE);
    }
}
