<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AddUniqueToPermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        try {
            DB::statement('SET FOREIGN_KEY_CHECKS=0;');

            Schema::table(
                'inside_roles_permissions_schema',
                function (Blueprint $table) {
                    $table->unique(
                        ['role_id', 'permission_schema_id', 'is_content_specific'],
                        'roles_permission_unique'
                    );
                }
            );

            Schema::table(
                'inside_users_permissions_schema',
                function (Blueprint $table) {
                    $table->unique(['user_uuid', 'permission_schema_id'], 'users_permission_unique');
                }
            );

            Schema::table(
                'inside_permissions_schema',
                function (Blueprint $table) {
                    $table->unique(
                        [
                            'invert',
                            'children',
                            'action',
                            'authorizable_type',
                            'authorizable_uuid',
                        ],
                        'schema_unique'
                    );
                }
            );

            Schema::table(
                'inside_permissions',
                function (Blueprint $table) {
                    $table->unique(
                        [
                            'role_id',
                            'action',
                            'uuid',
                            'type',
                        ],
                        'role_unique'
                    );

                    $table->unique(
                        [
                            'user_uuid',
                            'action',
                            'uuid',
                            'type',
                        ],
                        'user_unique'
                    );
                }
            );

            DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        } catch (Exception $e) {
            //
        }
    }
}
