<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AlterPermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Truncate it
        try {
            DB::statement('SET FOREIGN_KEY_CHECKS=0;');
            DB::table('inside_roles_permissions')->truncate();
            DB::table('inside_permissions')->truncate();
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        } catch (Exception $e) {
            //
        }

        if (Schema::hasTable('inside_permissions')) {
            Schema::table(
                'inside_permissions',
                function (Blueprint $table) {
                    $table->uuid('user_uuid')->collate('utf8')->nullable();
                    $table->integer('role_id')->collate('utf8')->unsigned()->nullable();

                    $table->string('action', 255)->nullable();
                    $table->uuid('uuid')->collate('utf8')->nullable();

                    $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
                    $table->foreign('role_id')->references('id')->on('inside_roles')->onDelete('cascade');
                }
            );

            Schema::table(
                'inside_permissions',
                function (Blueprint $table) {
                    $table->dropColumn('name');
                }
            );
        }
    }
}
