<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create(
            'inside_permissions',
            function (Blueprint $table) {
                $table->increments('id')->collate('utf8');
                $table->string('name', 255);
            }
        );

        Schema::create(
            'inside_roles',
            function (Blueprint $table) {
                $table->increments('id')->collate('utf8');
                $table->string('name', 255);
            }
        );

        Schema::create(
            'inside_roles_permissions',
            function (Blueprint $table) {
                $table->increments('id');
                $table->integer('role_id')->collate('utf8')->unsigned();
                $table->integer('permission_id')->collate('utf8')->unsigned();
                $table->foreign('role_id')->references('id')->on('inside_roles')->onDelete('cascade');
                $table->foreign('permission_id')->references('id')->on('inside_permissions')->onDelete('cascade');
            }
        );

        Schema::create(
            'inside_users_permissions',
            function (Blueprint $table) {
                $table->increments('id');
                $table->uuid('user_uuid')->collate('utf8');
                $table->integer('permission_id')->collate('utf8')->unsigned();
                $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
                $table->foreign('permission_id')->references('id')->on('inside_permissions')->onDelete('cascade');
            }
        );

        Schema::create(
            'inside_users_roles',
            function (Blueprint $table) {
                $table->increments('id');
                $table->uuid('user_uuid')->collate('utf8');
                $table->integer('role_id')->collate('utf8')->unsigned();
                $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
                $table->foreign('role_id')->references('id')->on('inside_roles')->onDelete('cascade');
            }
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inside_roles_permissions');
        Schema::dropIfExists('inside_users_permissions');
        Schema::dropIfExists('inside_users_roles');
        Schema::dropIfExists('inside_roles');
        Schema::dropIfExists('inside_permissions');
    }
}
