<?php

use Inside\Authentication\Models\User;
use Inside\Permission\Facades\Permission;

return [
    'debug' => env('PERMISSION_DEBUG', false),

    'specific_permissions_enabled' => env('SPECIFIC_PERMISSIONS_ENABLED', true),

    // Hidden content type in backend
    'hidden_types'                                    => [
        'newsletters',
    ],
    // Locked roles
    'locked'                                          => [

    ],
    //   'global_scope' => function ($builder, $user, $model) {
    //
    //    },
    //  'in_add_list' => [
    //    function(string $type): bool {
    //      return true;
    //  },
    // ],
    // Liste des types de contenus dont malgré le fait que je sois l'auteur du contenu,
    // il faut explicitement que j'ai le droit de modifier et/ou d'effacer le contenu
    'non_implicit_permission_to_author_content_types' => [

    ],
    // These roles can see unpublished content
    'special_roles'                                   => [
        'super_administrator',
        'administrator',
        'webmaster',
    ],
    //This is a custom callback when permission fails, we grant the possibility
    // to allow something
    'custom_permissions'  => [
        'allow_newsletter' => function (string $action, string $type, $uuid, ?User $user) {
            return $type === 'newsletters' && $user && Permission::backofficeAccessibleEntries($user)->contains('newsletter');
        },
        'allow_comments_delete' => function (string $action, string $type, $uuid, ?User $user) {
            return $type === 'comments' &&
                $action == 'delete' &&
                $user && type_to_class($type)::query()
                    ->where('uuid', $uuid)
                    ->where('author', $user->uuid)
                    ->exists();
        },
    ],
    /**
     * This is a custom callback if you wan't to forbid a $path, return false
     */
    //'custom_protected_resource_permissions'  => [
    //     function (string $path) {
    //          return false;
    //    }
    //],
    /**
     * This is a custom callback to define if the base permission scope should be set
     */
    //'apply_permission_scope' => function($user, $model) {
    //
    //}
    // System backoffice permission that can only be accessed by super admins from maecia
    'system_backoffice_entries' => [
        'permission',
        'system',
        'translation',
    ],
    // Override the default permission for a specific content type
    // It's use by newsletter to restrict access to some content
    'custom_access_restriction' => [
        // 'content_type' => function (User $user, Content $content): bool
    ],
];
