<?php

namespace Inside\Notify\Services;

use Illuminate\Database\Eloquent\Builder;
use Inside\Notify\Models\Notification;

class ExpiredNotificationCleanerService
{
    public function execute(): void
    {
        if (! config('notify.cleaner.enabled')) {
            return;
        }

        $viewedNotificationsDaysAge = now()->subDays(config('notify.cleaner.viewed_notifications_expiry_days'));
        $defaultNotificationsDaysAge = now()->subDays(config('notify.cleaner.notifications_expiry_days'));

        $notifications = Notification::query()
            ->where('created_at', '<', $defaultNotificationsDaysAge)
            ->orWhereHas('view', fn (Builder $query) => $query->where('read_at', '<', $viewedNotificationsDaysAge))
            ->delete();
    }
}
