<?php

namespace Inside\Notify\Notifications;

use Inside\Jobs\Queue\Middleware\RateLimited;
use Inside\Jobs\Queue\Middleware\WithoutOverlapping;
use Inside\Notify\Channels\SmsChannel;
use Inside\Notify\Facades\SMS;

/**
 * SMS notification.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class SmsNotification extends InsideNotification
{
    public function via(mixed $notifiable): array
    {
        if (is_null($this->user)) {
            return [];
        }

        return [SmsChannel::class];
    }

    public function toSms(): mixed
    {
        return SMS::getMessageFromNotification($this);
    }

    public function middleware(): array
    {
        if (is_null($this->user)) {
            return [];
        }

        return [
            new WithoutOverlapping($this->user->id),
            new RateLimited('notification'),
        ];
    }
}
