<?php

namespace Inside\Notify\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Carbon;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * Inside\Notify\Models\SendinblueSmsQuota
 *
 * @property int $id
 * @property int $sms_count
 * @property mixed $used_credits
 * @property mixed $remaining_credits
 * @property Carbon $start_date
 * @property Carbon $end_date
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @method static Builder|SmsQuota newModelQuery()
 * @method static Builder|SmsQuota newQuery()
 * @method static Builder|SmsQuota query()
 * @method static Builder|SmsQuota whereCreatedAt($value)
 * @method static Builder|SmsQuota whereEndDate($value)
 * @method static Builder|SmsQuota whereId($value)
 * @method static Builder|SmsQuota whereRemainingCredits($value)
 * @method static Builder|SmsQuota whereSmsCount($value)
 * @method static Builder|SmsQuota whereStartDate($value)
 * @method static Builder|SmsQuota whereUpdatedAt($value)
 * @method static Builder|SmsQuota whereUsedCredits($value)
 *
 * @mixin \Eloquent
 * @mixin Builder
 */
class SmsQuota extends Model
{
    use WithEnhancedBuilder;

    protected $table = 'sms_quotas';

    protected $guarded = [];
}
