<?php

namespace Inside\Notify\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Carbon;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * Inside\Notify\Models\SendinbluePlan
 *
 * @method static \Inside\Database\Eloquent\Builder|SendinbluePlan newModelQuery()
 * @method static \Inside\Database\Eloquent\Builder|SendinbluePlan newQuery()
 * @method static \Inside\Database\Eloquent\Builder|SendinbluePlan query()
 * @property int $id
 * @property float $used_credits
 * @property float $remaining_credits
 * @property string $start_date
 * @property string $end_date
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @method static Builder|SendinbluePlan whereCreatedAt($value)
 * @method static Builder|SendinbluePlan whereEndDate($value)
 * @method static Builder|SendinbluePlan whereId($value)
 * @method static Builder|SendinbluePlan whereRemainingCredits($value)
 * @method static Builder|SendinbluePlan whereStartDate($value)
 * @method static Builder|SendinbluePlan whereUpdatedAt($value)
 * @method static Builder|SendinbluePlan whereUsedCredits($value)
 *
 * @mixin \Eloquent
 * @mixin Builder
 */
class SendinbluePlan extends Model
{
    use WithEnhancedBuilder;

    protected $table = 'sendinblue_plans';

    protected $dates = [
        'start_date',
        'end_date',
    ];

    protected $casts = [
        'used_credits' => 'decimal:2',
        'remaining_credits' => 'decimal:2',
    ];

    protected $guarded = [];
}
