<?php

namespace Inside\Notify\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Inside\Content\Models\Contents\Users;
use Inside\Content\Models\Model;

/**
 * Inside Notification model.
 *
 * @category Class
 * @author Maecia <technique@maecia.com>
 * @license http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link http://www.maecia.com/
 * @property int $id
 * @property int $notification_id
 * @property string $user_uuid
 * @property int|null $view_at
 * @property int|null $read_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\Inside\Content\Models\Field[] $fields
 * @property-read int|null $fields_count
 * @property-read mixed $model
 * @property-read Notification $notification
 * @property-read Users $user
 * @method static Builder|NotificationUserView newModelQuery()
 * @method static Builder|NotificationUserView newQuery()
 * @method static Builder|NotificationUserView query()
 * @method static Builder|NotificationUserView whereId($value)
 * @method static Builder|NotificationUserView whereNotificationId($value)
 * @method static Builder|NotificationUserView whereReadAt($value)
 * @method static Builder|NotificationUserView whereUserUuid($value)
 * @method static Builder|NotificationUserView whereViewAt($value)
 *
 * @mixin Builder
 * @mixin \Eloquent
 */
class NotificationUserView extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_notifications_users_views';

    protected $fillable = [
        'user_uuid',
        'notification_id',
        'view_at',
        'read_at',
    ];

    protected $casts = [
        'view_at' => 'timestamp',
        'read_at' => 'timestamp',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(Users::class, 'user_uuid', 'uuid');
    }

    public function notification(): BelongsTo
    {
        return $this->belongsTo(Notification::class, 'notification_id', 'id');
    }
}
