<?php

namespace Inside\Notify\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * Inside\Notify\Models\NotificationPushDevice
 *
 * @property int $id
 * @property string $onesignal_player_id
 * @property string $user_uuid
 * @property string $type
 * @method static Builder|NotificationPushDevice newModelQuery()
 * @method static Builder|NotificationPushDevice newQuery()
 * @method static Builder|NotificationPushDevice query()
 * @method static Builder|NotificationPushDevice whereId($value)
 * @method static Builder|NotificationPushDevice whereOnesignalPlayerId($value)
 * @method static Builder|NotificationPushDevice whereType($value)
 * @method static Builder|NotificationPushDevice whereUserUuid($value)
 *
 * @mixin \Eloquent
 * @mixin Builder
 */
class NotificationPushDevice extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_notifications_push_devices';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'onesignal_player_id',
        'user_uuid',
        'type',
    ];

    /**
     * The table without the timestamps.
     *
     * @var bool
     */
    public $timestamps = false;
}
