<?php

namespace Inside\Notify\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * Inside Notification Log model.
 *
 * @category Class
 * @author Maecia <technique@maecia.com>
 * @license http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link http://www.maecia.com/
 * @property int $id
 * @property array $roles
 * @method static Builder|NotificationLog newModelQuery()
 * @method static Builder|NotificationLog newQuery()
 * @method static Builder|NotificationLog query()
 * @method static Builder|NotificationLog whereId($value)
 * @method static Builder|NotificationLog whereNotificationId($value)
 * @method static Builder|NotificationLog whereRoleId($value)
 *
 * @mixin \Eloquent
 * @mixin Builder
 */
class NotificationLog extends Model
{
    use WithEnhancedBuilder;

    protected $table = 'inside_notification_logs';

    protected $fillable = [
        'queued_job_id',
        'content_type',
        'content_uuid',
        'sent_at',
        'channel',
        'roles',
        'status',
    ];

    protected $casts = [
        'sent_at' => 'datetime',
        'roles' => 'array',
    ];
}
