<?php

declare(strict_types=1);

namespace Inside\Notify\Messages;

use Illuminate\Notifications\Messages\MailMessage as BaseMailMessage;

/**
 * Mail message.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class MailMessage extends BaseMailMessage
{
    /**
     * The model of the notification.
     *
     * @var mixed
     */
    public $model;

    /**
     * The recipient of the notification.
     *
     * @var mixed
     */
    public $recipient;

    /**
     * Current mail theme
     *
     * @var string|null
     */
    public $theme;

    /**
     * @var string|null
     */
    public $image;

    /**
     * Add a model to the notification.
     *
     * @param mixed $model
     * @return $this
     */
    public function model($model): self
    {
        $this->model = $model;

        return $this;
    }

    /**
     * Add a recipient to the notification.
     *
     * @param mixed $recipient
     * @return $this
     */
    public function recipient($recipient): self
    {
        $this->recipient = $recipient;

        return $this;
    }

    public function image(string $image = null): self
    {
        $this->image = $image;

        return $this;
    }

    /**
     * Set mail message theme
     *
     * @param string|null $theme
     * @return $this
     */
    public function theme($theme): self
    {
        $this->theme = $theme;

        return $this;
    }

    /**
     * Get an array representation of the message.
     *
     * @return array
     */
    public function toArray(): array
    {
        return [
            'level' => $this->level,
            'subject' => $this->subject,
            'greeting' => $this->greeting,
            'salutation' => $this->salutation,
            'introLines' => $this->introLines,
            'outroLines' => $this->outroLines,
            'actionText' => $this->actionText,
            'actionUrl' => $this->actionUrl,
            'displayableActionUrl' => str_replace(['mailto:', 'tel:'], '', $this->actionUrl),
            'model' => $this->model,
            'recipient' => $this->recipient,
            'image' => $this->image,
        ];
    }
}
