<?php

namespace Inside\Notify\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Log;
use Inside\Authentication\Models\User;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;
use Inside\Notify\Models\NotificationTypeRole;
use Inside\User\Events\UserEnabledEvent;

/**
 * User login listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class UserEnabledListener implements ShouldQueue
{
    /**
     * @param  UserEnabledEvent  $event
     */
    public function handle(UserEnabledEvent $event): void
    {
        $user = User::find($event->userUuid);

        if (! $user instanceof User) {
            return;
        }

        Log::info('[user-enabled] Inscription aux notifications par défaut de <'.$event->userUuid.'>');
        $roles = $user->roles->pluck('id');
        $roleTypes = NotificationTypeRole::whereIn('role_id', $roles)->pluck('notification_type_id');
        $types = NotificationType::where('default', true)
            ->orWhereIn('id', $roleTypes)
            ->get();

        foreach ($types as $type) {
            NotificationSubscriber::firstOrCreate([
                'notification_type_id' => $type->id,
                'user_uuid' => $user->uuid,
            ]);
        }
    }
}
