<?php

namespace Inside\Notify\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Authentication\Models\User;
use Inside\Content\Events\ContentUpdatedEvent;
use Inside\Notify\Models\NotificationType;

/**
 * Test email updated listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class TestEmailUpdatedListener extends BaseNotificationListener implements ShouldQueue
{
    /**
     * @param  ContentUpdatedEvent  $event
     */
    public function handle(ContentUpdatedEvent $event): void
    {
        $model = $event->model;

        $types = NotificationType::where('model', get_class($model))->where(function ($query) {
            $query->where('action', 'testEmail');
        })->get();

        foreach ($types as $type) {
            $emails = $model->test_email ?? '';
            $emails = explode(',', $emails);
            $subscribers = User::query()->whereIn('email', $emails)->get();

            $subscribers->each(function ($subscriber) use ($type, $model) {
                $this->when = $this->getInterval($type, $model);
                $this->route = $subscriber;
                $this->notify($type, $subscriber, $model, ['from' => $model->author]);
            });
        }
    }
}
