<?php

namespace Inside\Notify\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Notify\Events\CustomNotificationEvent;
use Inside\Notify\Models\NotificationType;
use Inside\Support\Str;

/**
 * Custom notifications listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class CustomNotificationListener extends BaseNotificationListener implements ShouldQueue
{
    /**
     * @param  CustomNotificationEvent  $event
     */
    public function handle(CustomNotificationEvent $event): void
    {
        $model = null;
        $query = NotificationType::where('event', CustomNotificationEvent::class)
            ->where('action', $event->data['action']);

        if (isset($event->data['model'])) {
            $query->where('model', 'Inside\Content\Models\Contents\\'.Str::studly($event->data['model']));
        }
        $types = $query->get();

        if (isset($event->data['uuid']) && isset($event->data['model'])) {
            $model = call_user_func(
                'Inside\Content\Models\Contents\\'.Str::studly($event->data['model']).'::find',
                $event->data['uuid']
            );
        }
        $user = $event->user;

        foreach ($types as $type) {
            if ($type->role && $type->via !== 'email') {
                $this->route = $type->roles->first();
                // Condition needs a model
                if (! empty($type->condition) && ! $model) {
                    continue;
                }

                if ($model && ! $this->checkConditions($type, $model)) {
                    continue;
                }
                $this->notify($type, null, $model, ['from' => $user->uuid], $type->roles->pluck('id'));
            } else {
                $type->subscribers->each(function ($subscriber) use ($type, $model, $user) {
                    $this->route = $subscriber;

                    if ($subscriber->status != 1) {
                        return;
                    }
                    // Condition needs a model
                    if (! empty($type->condition) && ! $model) {
                        return;
                    }

                    if ($model &&
                        (
                            ! $this->checkConditions($type, $model, $subscriber) ||
                            ! $this->checkUniqueness($type, $model, $subscriber)
                        )
                    ) {
                        return;
                    }

                    $roles = $type->role ? $type->roles->pluck('name')->toArray() : [];

                    $this->notify($type, $subscriber, $model, ['from' => $user->uuid], $roles);
                });
            }
        }
    }
}
