<?php

namespace Inside\Notify\Jobs;

use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Artisan;
use Inside\Authentication\Models\User;
use Inside\Jobs\Job;
use Inside\Permission\Models\Role;

/**
 * Class Cleanup
 */
class Cleanup extends Job
{
    public function handle(): void
    {
        // Clean user notifications
        User::each(function (User $user) {
            CleanupUserNotifications::dispatch($user);
        });

        // Clean role notifications
        Role::each(function (Role $role) {
            CleanupRoleNotifications::dispatch($role);
        });

        // Clean notifications notifiable type
        Artisan::call('notif:clean');
    }
}
