<?php

namespace Inside\Notify\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Inside\Notify\Models\NotificationPushDevice;
use Symfony\Component\HttpFoundation\Response;

class NotificationPushDeviceController
{
    public function post(Request $request): NotificationPushDevice
    {
        $user = Auth::user();

        $type = $request->input('type');
        $playerId = $request->input('onesignal_player_id');

        if (empty($playerId) || empty($type) || ! in_array($type, ['mobile', 'desktop'])) {
            abort(Response::HTTP_BAD_REQUEST, 'Invalid body');
        }

        return NotificationPushDevice::updateOrCreate([
            'type' => $type,
            'onesignal_player_id' => $playerId,
            'user_uuid' => $user->uuid,
        ]);
    }

    public function list(): Collection
    {
        $user = Auth::user();

        return NotificationPushDevice::query()
            ->where('user_uuid', '=', $user->uuid)
            ->get();
    }

    public function delete(string $playerId): void
    {
        $user = Auth::user();

        $device = NotificationPushDevice::query()
            ->where('user_uuid', '=', $user->uuid)
            ->where('onesignal_player_id', '=', $playerId)
            ->first();

        if ($device instanceof NotificationPushDevice) {
            $device->delete();
        }
    }
}
