<?php

namespace Inside\Notify\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Inside\Notify\Services\NotificationLogService;

/**
 * Notification Log controller.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class NotificationLogController
{
    public function __construct(private NotificationLogService $notificationLogService)
    {
    }

    public function get(string $type, string $uuid): JsonResponse
    {
        return response()->json([
            'data' => $this->notificationLogService->getLogs($uuid, $type),
        ]);
    }

    public function delete(int $notificationLogId): JsonResponse
    {
        $response = $this->notificationLogService->cancelScheduledNotification($notificationLogId);
        $status = $response['success'] ? 200 : 400;

        return response()->json(['message' => $response['message']], $status);
    }
}
