<?php

namespace Inside\Notify\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Events\Dispatchable;

class NotificationsManualsEvent
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    /**
     * @var string
     */
    public $contentId;

    /**
     * The roles.
     *
     * @var array
     */
    public $roleIds;

    /**
     * @var array
     */
    public $channels;

    /**
     * @var string
     */
    public $contentType;

    /**
     * @var Authenticatable|User|null
     */
    public $user;

    /**
     * Create a new notification created event instance.
     *
     * @param  string  $contentId
     * @param  array  $roleIds
     * @param  array  $channels
     * @param  string  $contentType
     */
    public function __construct(string $contentId, array $roleIds, array $channels, string $contentType)
    {
        $this->contentId = $contentId;
        $this->roleIds = $roleIds;
        $this->channels = $channels;
        $this->contentType = $contentType;
        $this->user = App::runningInConsole() ? User::where('email', config('app.technical_mail'))->first() : Auth::user();
    }
}
