<?php

namespace Inside\Notify\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Inside\Events\Dispatchable;
use Inside\Notify\Models\Notification;

/**
 * Notification deleted event.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class NotificationDeletedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use Dispatchable;

    /**
     * The notification.
     *
     * @var Notification
     */
    public $notification;

    /**
     * Create a new notification created event instance.
     *
     * @param  Notification  $notification
     */
    public function __construct(Notification $notification)
    {
        $this->notification = $notification;
    }

    /**
     * @inheritDoc
     */
    public function broadcastOn()
    {
        return new PrivateChannel('inside.notifications.'.$this->notification->user_uuid);
    }

    /**
     * event broadcast name
     *
     * @return string
     */
    public function broadcastAs()
    {
        return 'inside.notification.deleted';
    }
}
