<?php

namespace Inside\Notify\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Support\Arr;
use Inside\Events\Dispatchable;
use Inside\Notify\Facades\Notification as NotificationService;
use Inside\Notify\Models\Notification;

/**
 * Notification created event.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class NotificationCreatedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use Dispatchable;

    /**
     * The notification.
     *
     * @var Notification
     */
    public $notification;

    /**
     * Create a new notification created event instance.
     *
     * @param  Notification  $notification
     */
    public function __construct(Notification $notification)
    {
        $this->notification = $notification;
    }

    /**
     * @inheritDoc
     */
    public function broadcastOn(): PrivateChannel
    {
        return new PrivateChannel('inside.notifications.'.$this->notification->user_uuid);
    }

    /**
     * event broadcast name
     *
     * @return string
     */
    public function broadcastAs(): string
    {
        return 'inside.notification.created';
    }

    public function broadcastWith(): array
    {
        return [
            'notification' => Arr::first(NotificationService::transform([$this->notification])),
        ];
    }
}
